module net.BurtonRadons.dig.platform.clipboard;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.windows;

//private import std.string;

/** The clipboard control, statically std.math.singleton instantiated in
  * Control::clipboard.  OSes accept and return clipboard information
  * in a set of possible formats; you register the formats here.
  */

class Clipboard
{
/* general: */
    /** Open the clipboard for examination.  This avoids collisions
      * by not allowing other windows to handle it until after you're done.
      * You must call @a close.  This can return false; that means that
      * another program has it opened at present.
      */

    bit open ()
    {
        if (!OpenClipboard ((_HANDLE) 0))
        {
            digPlatformGetLastError ("Clipboard.open: OpenClipboard");
            return false;
        }
        return true;
    }

    /** Close the clipboard after it was opened.
      */

    void close ()
    {
        if (!CloseClipboard ())
            digPlatformGetLastError ("Clipboard.close: CloseClipboard");
    }

/* reading: */
    /** Get the text format for this clipboard data, returns null if there is none. */
    char [] getText ()
    {
        _HANDLE handle;

        handle = (_HANDLE) GetClipboardData (CF_TEXT);
        if (handle == (_HANDLE) 0)
        {
            digPlatformGetLastError ("Clipboard.getText: GetClipboardData");
            return null;
        }

        char *data = (char *) GlobalLock (handle);
        if (data === null)
            return null;

        char [] text;

        try
        {
            text = data [0 .. std.string.strlen (data)].dup;
            text = std.string.replace (text, "\r\n", "\n");
        }
        finally GlobalUnlock (handle);

        return text;
    }

/* writing: */
    /** Empty the clipboard, freeing its data. */
    void empty ()
    {
        EmptyClipboard ();
    }

    /** Add a text format to the supported content. */
    void addText (char [] text)
    {
        _HGLOBAL global;

        text = std.string.replace (text, "\n", "\r\n");

        global = GlobalAlloc (GMEM_MOVEABLE, text.length + 1);
        if (global == (_HANDLE) 0)
            digPlatformGetLastError ("Clipboard.addText: GlobalAlloc");
        char *output = (char *) GlobalLock (global);

        try
        {
            output [0 .. text.length] = text;
            output [text.length] = 0;
        }
        finally GlobalUnlock (global);

        SetClipboardData (CF_TEXT, global);
    }
}
